#ifndef X509AT_H
#define X509AT_H

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef OPENSSL_NO_STDIO
#define APPS_WIN16
#endif

#ifdef ESTOY_COMPILANDO
 #include <crypto/cryptlib.h>
#elseif
 #include "cryptlib.h"
#endif


#include <openssl/asn1t.h>
#include <openssl/asn1_mac.h>

#include <openssl/bio.h>
#include <openssl/asn1.h>
#include <openssl/err.h>
#include <openssl/bn.h>
#include <openssl/evp.h>
#include <openssl/x509.h>
#include <openssl/x509v3.h>
#include <openssl/objects.h>
#include <openssl/pem.h>
#include <openssl/stack.h>
#include <openssl/safestack.h>




#define OBJECTDIGESTINFO_PUBLICKEY 0
#define OBJECTDIGESTINFO_PUBLICKEYCERT 1
#define OBJECTDIGESTINFO_OTHEROBJECTTYPES 2



typedef struct X509AT_val_st
	{
	ASN1_GENERALIZEDTIME *notBeforeTime;
	ASN1_GENERALIZEDTIME  *notAfterTime;
	} X509AT_VAL;


typedef struct x509AT_attributes_st
	{
	ASN1_OBJECT *object;
	int single; /* 0 for a set, 1 for a single item (which is wrong) */
	union	{
			char		*ptr;
/* 0 */		STACK_OF(ASN1_TYPE) *set;
/* 1 */		ASN1_TYPE	*single;
		} value;
	} X509AT_ATTRIBUTE;

DECLARE_STACK_OF(X509AT_ATTRIBUTE)
DECLARE_ASN1_SET_OF(X509AT_ATTRIBUTE)

typedef struct X509AT_objectDigestInfo_st
	{
	ASN1_ENUMERATED *digestedObjectType;
	ASN1_OBJECT *otherObjectTypeID;
	X509_ALGOR *digestAlgorithm;
	ASN1_BIT_STRING *objectDigest;
	}X509AT_OBJECTDIGESTINFO;


typedef struct x509AT_issuer_serial_st
	{
	GENERAL_NAMES *issuer;
	ASN1_INTEGER *serial;
	ASN1_BIT_STRING *issuerUID;
	} X509AT_ISSUER_SERIAL;

typedef struct x509AT_holder_st
	{
	X509AT_ISSUER_SERIAL *baseCertificateID;
	GENERAL_NAMES *entityName;
	X509AT_OBJECTDIGESTINFO *objectDigestInfo;
	}X509AT_HOLDER;

typedef struct x509AT_v2Form_st
	{
	GENERAL_NAMES *issuerName;
	X509AT_ISSUER_SERIAL *baseCertificateID;
	X509AT_OBJECTDIGESTINFO *objectDigestInfo;
	}X509AT_V2FORM;


typedef struct x509AT_attCertIssuer_st
	{
	int type;
	union {
		char *ptr;
		GENERAL_NAMES *v1Form;
		X509AT_V2FORM *v2Form;
		}value;
	}X509AT_ATTCERTISSUER;

DECLARE_STACK_OF(X509AT_V2FORM)
DECLARE_ASN1_SET_OF(X509AT_V2FORM)



typedef struct x509AT_cinf_st
	{
	ASN1_INTEGER *version;		/* default of v2 */
	X509AT_HOLDER *holder;
	X509AT_ATTCERTISSUER *issuer;
	X509_ALGOR *signature;
	ASN1_INTEGER *serialNumber;
	X509AT_VAL *attrCertValidityPeriod;
	STACK_OF(X509AT_ATTRIBUTE) *attributes;
	ASN1_BIT_STRING *issuerUID;		/*optional*/
	STACK_OF(X509_EXTENSION) *extensions;	/*optional*/
	} X509AT_CINF;


typedef struct x509AT_at_st
	{
	X509AT_CINF *cert_info_at;
	X509_ALGOR *sig_alg;
	ASN1_BIT_STRING *signature;
	int valid;
	int references;
	char *name;
	CRYPTO_EX_DATA ex_data;
	/* These contain copies of various extension values */
	long ex_pathlen;
	unsigned long ex_flags;
	unsigned long ex_kusage;
	unsigned long ex_xkusage;
	unsigned long ex_nscert;
	ASN1_OCTET_STRING *skid;
	struct AUTHORITY_KEYID_st *akid;
#ifndef OPENSSL_NO_SHA
	unsigned char sha1_hash[SHA_DIGEST_LENGTH];
#endif
	X509_CERT_AUX *aux;
	}X509AT;


DECLARE_STACK_OF(X509AT_OBJECTDIGESTINFO)
DECLARE_ASN1_SET_OF(X509AT_OBJECTDIGESTINFO)

DECLARE_STACK_OF(X509AT_ISSUER_SERIAL)
DECLARE_ASN1_SET_OF(X509AT_ISSUER_SERIAL)

DECLARE_STACK_OF(X509AT_ATTCERTISSUER)
DECLARE_ASN1_SET_OF(X509AT_ATTCERTISSUER)

DECLARE_STACK_OF(X509AT_HOLDER)
DECLARE_ASN1_SET_OF(X509AT_HOLDER)

/* Por si necesitas declarar STACK_OF (Type)*/
DECLARE_STACK_OF(X509AT)
DECLARE_ASN1_SET_OF(X509AT)


#ifdef  __cplusplus
extern "C" {
#endif

#define		X509AT_get_version(x)   ASN1_INTEGER_get((x)->cert_info_at->version)
#define		X509AT_get_notBefore(x) ((x)->cert_info_at->attrCertValidityPeriod->notBeforeTime)
#define		X509AT_get_notAfter(x)  ((x)->cert_info_at->attrCertValidityPeriod->notAfterTime)
#define X509AT_VERSION_V1 0
#define X509AT_VERSION_V2 1


/************ DEFINICIONES DE X509AT_funcs.c ****************************/
void * getValue(GENERAL_NAME *gn);
int hexToText(const char *hex,int length, char **text);

char *X509AT_get_issuer_info(X509AT *a);
char *X509AT_get_holder_info(X509AT *a);
char *X509AT_get_att_info(X509AT *a);
int X509AT_sign(X509AT *x, EVP_PKEY *pkey, const EVP_MD *md);

int X509AT_digestF(const X509AT *data,const EVP_MD *type, unsigned char *md,unsigned int *len);
int X509AT_alias_set1(X509AT *x, unsigned char *name, int len);
unsigned char *X509AT_alias_get0(X509AT *x, int *len);
int X509AT_add1_trust_object(X509AT *x, ASN1_OBJECT *obj);
int X509AT_add1_reject_object(X509AT *x, ASN1_OBJECT *obj);
void X509AT_trust_clear(X509AT *x);
void X509AT_reject_clear(X509AT *x);

int X509AT_print(BIO *bp, X509AT *x);
int X509AT_print_ex(BIO *bp, X509AT *x, unsigned long nmflags, unsigned long cflag);


/*GENERAL_NAME *GENERAL_NAME_dup(GENERAL_NAME *gn);*/
char *X509AT_getOneLine_attributes(X509AT *a);
int X509AT_check_purpose(X509AT *xAT, int id, int ca);

int X509AT_issuer_and_serial_cmp(const X509AT *a, const X509AT *b);
int ASN1_OBJECT_cmp (const ASN1_OBJECT *a,const ASN1_OBJECT *b);
int EDIPARTYNAME_cmp(const EDIPARTYNAME *a,const EDIPARTYNAME *b);
int OTHERNAME_cmp (const OTHERNAME *a,const OTHERNAME *b);
int GENERAL_NAMES_cmp(const GENERAL_NAMES *a, const GENERAL_NAMES *b);
int ASN1_TYPE_cmp (const ASN1_TYPE *a, const  ASN1_TYPE *b);
int X509_ALGOR_cmp(const X509_ALGOR *a, const X509_ALGOR *b);
int X509AT_ISSUER_SERIAL_cmp(const X509AT_ISSUER_SERIAL *a,const X509AT_ISSUER_SERIAL *b);
int X509AT_OBJECTDIGESTINFO_cmp(const X509AT_OBJECTDIGESTINFO *a, const X509AT_OBJECTDIGESTINFO *b);
int X509AT_ATTCERTISSUER_cmp(const X509AT_ATTCERTISSUER *a,const X509AT_ATTCERTISSUER *b);
int X509AT_V2FORM_cmp(const X509AT_V2FORM *a,const X509AT_V2FORM *b);
int X509AT_HOLDER_cmp(const X509AT_HOLDER *a,const X509AT_HOLDER *b);
int X509AT_issuer_cmp(const X509AT *a, const X509AT *b);
int X509AT_holder_cmp(const X509AT *a, const X509AT *b);
X509AT_HOLDER *X509AT_get_holder(X509AT *a);
X509AT_ATTCERTISSUER *X509AT_get_issuer(X509AT *a);
unsigned long X509AT_issuer_hash(X509AT *x);
ASN1_INTEGER *X509AT_get_serialNumber(X509AT *a);
unsigned long X509AT_holder_hash(X509AT *x);
int X509AT_cmp(const X509AT *a, const X509AT *b);
int X509AT_set_version(X509AT *x, long version);
int X509AT_set_serialNumber(X509AT *x, ASN1_INTEGER *serial);
int X509AT_set_notBefore(X509AT *x, ASN1_TIME *tm);
int X509AT_set_notAfter(X509AT *x, ASN1_TIME *tm);
int X509AT_set_attcertissuer(X509AT *x, X509AT_ATTCERTISSUER *issuer);
int X509AT_set_holder(X509AT *x, X509AT_HOLDER *holder);
int X509AT_ATTCERTISSUER_set(X509AT_ATTCERTISSUER **xn, X509AT_ATTCERTISSUER *name);
int X509AT_V2FORM_set(X509AT_V2FORM **xn, X509AT_V2FORM *name);
int X509AT_HOLDER_set(X509AT_HOLDER **xn, X509AT_HOLDER *name);
/*X509AT_ATTCERTISSUER *X509AT_ATTCERTISSUER_dup(X509AT_ATTCERTISSUER *in);*/
/************************************************************************/

/************ DEFINICIONES DE X509AT_att.c ******************************/
#define sk_X509AT_ATTRIBUTE_new(st) SKM_sk_new(X509AT_ATTRIBUTE, (st))
#define sk_X509AT_ATTRIBUTE_new_null() SKM_sk_new_null(X509AT_ATTRIBUTE)
#define sk_X509AT_ATTRIBUTE_free(st) SKM_sk_free(X509AT_ATTRIBUTE, (st))
#define sk_X509AT_ATTRIBUTE_num(st) SKM_sk_num(X509AT_ATTRIBUTE, (st))
#define sk_X509AT_ATTRIBUTE_value(st, i) SKM_sk_value(X509AT_ATTRIBUTE, (st), (i))
#define sk_X509AT_ATTRIBUTE_set(st, i, val) SKM_sk_set(X509AT_ATTRIBUTE, (st), (i), (val))
#define sk_X509AT_ATTRIBUTE_zero(st) SKM_sk_zero(X509AT_ATTRIBUTE, (st))
#define sk_X509AT_ATTRIBUTE_push(st, val) SKM_sk_push(X509AT_ATTRIBUTE, (st), (val))
#define sk_X509AT_ATTRIBUTE_unshift(st, val) SKM_sk_unshift(X509AT_ATTRIBUTE, (st), (val))
#define sk_X509AT_ATTRIBUTE_find(st, val) SKM_sk_find(X509AT_ATTRIBUTE, (st), (val))
#define sk_X509AT_ATTRIBUTE_delete(st, i) SKM_sk_delete(X509AT_ATTRIBUTE, (st), (i))
#define sk_X509AT_ATTRIBUTE_delete_ptr(st, ptr) SKM_sk_delete_ptr(X509AT_ATTRIBUTE, (st), (ptr))
#define sk_X509AT_ATTRIBUTE_insert(st, val, i) SKM_sk_insert(X509AT_ATTRIBUTE, (st), (val), (i))
#define sk_X509AT_ATTRIBUTE_set_cmp_func(st, cmp) SKM_sk_set_cmp_func(X509AT_ATTRIBUTE, (st), (cmp))
#define sk_X509AT_ATTRIBUTE_dup(st) SKM_sk_dup(X509AT_ATTRIBUTE, st)
#define sk_X509AT_ATTRIBUTE_pop_free(st, free_func) SKM_sk_pop_free(X509AT_ATTRIBUTE, (st), (free_func))
#define sk_X509AT_ATTRIBUTE_shift(st) SKM_sk_shift(X509AT_ATTRIBUTE, (st))
#define sk_X509AT_ATTRIBUTE_pop(st) SKM_sk_pop(X509AT_ATTRIBUTE, (st))
#define sk_X509AT_ATTRIBUTE_sort(st) SKM_sk_sort(X509AT_ATTRIBUTE, (st))


int X509AT_at_get_attr_count(const STACK_OF(X509AT_ATTRIBUTE) *x);

int X509AT_at_get_attr_by_NID(const STACK_OF(X509AT_ATTRIBUTE) *x, int nid,
			  int lastpos);

int X509AT_at_get_attr_by_OBJ(const STACK_OF(X509AT_ATTRIBUTE) *sk, ASN1_OBJECT *obj,
			  int lastpos);

X509AT_ATTRIBUTE *X509AT_at_get_attr(const STACK_OF(X509AT_ATTRIBUTE) *x, int loc);

X509AT_ATTRIBUTE *X509AT_at_delete_attr(STACK_OF(X509AT_ATTRIBUTE) *x, int loc);

STACK_OF(X509AT_ATTRIBUTE) *X509AT_at_add1_attr(STACK_OF(X509AT_ATTRIBUTE) **x,
					 X509AT_ATTRIBUTE *attr);

STACK_OF(X509AT_ATTRIBUTE) *X509AT_at_add1_attr_by_OBJ(STACK_OF(X509AT_ATTRIBUTE) **x,
			const ASN1_OBJECT *obj, int type,
			const unsigned char *bytes, int len);

STACK_OF(X509AT_ATTRIBUTE) *X509AT_at_add1_attr_by_NID(STACK_OF(X509AT_ATTRIBUTE) **x,
			int nid, int type,
			const unsigned char *bytes, int len);

STACK_OF(X509AT_ATTRIBUTE) *X509AT_at_add1_attr_by_txt(STACK_OF(X509AT_ATTRIBUTE) **x,
			const char *attrname, int type,
			const unsigned char *bytes, int len);

X509AT_ATTRIBUTE *X509AT_ATTRIBUTE_create_by_NID(X509AT_ATTRIBUTE **attr, int nid,
	     int atrtype, const void *data, int len);

X509AT_ATTRIBUTE *X509AT_ATTRIBUTE_create_by_OBJ(X509AT_ATTRIBUTE **attr,
	     const ASN1_OBJECT *obj, int atrtype, const void *data, int len);

X509AT_ATTRIBUTE *X509AT_ATTRIBUTE_create_by_txt(X509AT_ATTRIBUTE **attr,
		const char *atrname, int type, const unsigned char *bytes, int len);

int X509AT_ATTRIBUTE_set1_object(X509AT_ATTRIBUTE *attr, const ASN1_OBJECT *obj);

int X509AT_ATTRIBUTE_set1_data(X509AT_ATTRIBUTE *attr, int attrtype, const void *data, int len);

int X509AT_ATTRIBUTE_count(X509AT_ATTRIBUTE *attr);

ASN1_OBJECT *X509AT_ATTRIBUTE_get0_object(X509AT_ATTRIBUTE *attr);

void *X509AT_ATTRIBUTE_get0_data(X509AT_ATTRIBUTE *attr, int idx,
					int atrtype, void *data);


ASN1_TYPE *X509AT_ATTRIBUTE_get0_type(X509AT_ATTRIBUTE *attr, int idx);


/************************************************************************/

/************            MACROS            ******************************/

#define X509AT_ATTRIBUTE_dup(xa) (X509AT_ATTRIBUTE *)ASN1_dup(\
		(int (*)())i2d_X509AT_ATTRIBUTE, \
		(char *(*)())d2i_X509AT_ATTRIBUTE,(char *)xa)

#define X509AT_VAL_dup(xa) (X509AT_VAL *)ASN1_dup(\
		(int (*)())i2d_X509AT_VAL, \
		(char *(*)())d2i_X509AT_VAL,(char *)xa)

#define X509AT_ATTRIBUTE_SET_dup(xa) (X509AT_ATTRIBUTE_SET *)ASN1_dup(\
		(int (*)())i2d_X509AT_ATTRIBUTE_SET, \
		(char *(*)())d2i_X509AT_ATTRIBUTE_SET,(char *)xa)

#define X509AT_ISSUER_SERIAL_dup(xa) (X509AT_ISSUER_SERIAL *)ASN1_dup(\
		(int (*)())i2d_X509AT_ISSUER_SERIAL, \
		(char *(*)())d2i_X509AT_ISSUER_SERIAL,(char *)xa)

#define X509AT_OBJECTDIGESTINFO_dup(xa) (X509AT_OBJECTDIGESTINFO *)ASN1_dup(\
		(int (*)())i2d_X509AT_OBJECTDIGESTINFO, \
		(char *(*)())d2i_X509AT_OBJECTDIGESTINFO,(char *)xa)

#define X509AT_V2FORM_dup(xa) (X509AT_V2FORM *)ASN1_dup(\
		(int (*)())i2d_X509AT_V2FORM, \
		(char *(*)())d2i_X509AT_V2FORM,(char *)xa)

#define X509AT_HOLDER_dup(xa) (X509AT_HOLDER *)ASN1_dup(\
		(int (*)())i2d_X509AT_HOLDER, \
		(char *(*)())d2i_X509AT_HOLDER,(char *)xa)

#define X509AT_ATTCERTISSUER_dup(xa) (X509AT_ATTCERTISSUER *)ASN1_dup(\
		(int (*)())i2d_X509AT_ATTCERTISSUER, \
		(char *(*)())d2i_X509AT_ATTCERTISSUER,(char *)xa)

#define X509AT_CINF_dup(xa) (X509AT_CINF *)ASN1_dup(\
		(int (*)())i2d_X509AT_CINF, \
		(char *(*)())d2i_X509AT_CINF,(char *)xa)

#define X509AT_dup(xa) (X509AT *)ASN1_dup(\
		(int (*)())i2d_X509AT, \
		(char *(*)())d2i_X509AT,(char *)xa)

#define ASN1_OBJECT_dup(xa) (ASN1_OBJECT *)ASN1_dup(\
		(int (*)())i2d_ASN1_OBJECT, \
		(char *(*)())d2i_ASN1_OBJECT,(char *)xa)

#define ASN1_TYPE_dup(xa) (ASN1_TYPE *)ASN1_dup(\
		(int (*)())i2d_ASN1_TYPE, \
		(char *(*)())d2i_ASN1_TYPE,(char *)xa)

#define ASN1_GENERALIZEDTIME_dup(xa) (ASN1_GENERALIZEDTIME *)ASN1_dup(\
		(int (*)())i2d_ASN1_GENERALIZEDTIME, \
		(char *(*)())d2i_ASN1_GENERALIZEDTIME,(char *)xa)

#define GENERAL_NAME_dup(xa) (GENERAL_NAME *)ASN1_dup(\
		(int (*)())i2d_GENERAL_NAME, \
		(char *(*)())d2i_GENERAL_NAME,(char *)xa)

#define GENERAL_NAMES_dup(xa) (GENERAL_NAMES *)ASN1_dup(\
		(int (*)())i2d_GENERAL_NAMES, \
		(char *(*)())d2i_GENERAL_NAMES,(char *)xa)

#define ASN1_ENUMERATED_dup(xa) (ASN1_ENUMERATED *)ASN1_dup(\
		(int (*)())i2d_ASN1_ENUMERATED, \
		(char *(*)())d2i_ASN1_ENUMERATED,(char *)xa)

#define ASN1_BIT_STRING_dup(xa) (ASN1_BIT_STRING *)ASN1_dup(\
		(int (*)())i2d_ASN1_BIT_STRING, \
		(char *(*)())d2i_ASN1_BIT_STRING,(char *)xa)

#define X509AT_digest(data,type,md,len) \
	ASN1_digest((int (*)())i2d_X509AT,type,(char *)data,md,len)

#define X509AT_verify(a,r) ASN1_verify((int (*)())i2d_X509AT_CINF,a->sig_alg,\
	a->signature,(char *)a->cert_info_at,r)

#define d2i_X509AT_bio(bp,x509AT) (X509AT *)ASN1_d2i_bio((char *(*)())X509AT_new, \
		(char *(*)())d2i_X509AT, (bp),(unsigned char **)(x509AT))

#define i2d_X509AT_bio(bp,x509AT) ASN1_i2d_bio(i2d_X509AT,bp,(unsigned char *)x509AT)

#define PEM_write_bio_X509AT(bp,x) \
		PEM_ASN1_write_bio((int (*)())i2d_X509AT,PEM_STRING_X509,bp, \
			(char *)x, NULL,NULL,0,NULL,NULL)

#define	PEM_read_bio_X509AT(bp,x,cb,u) (X509AT *)PEM_ASN1_read_bio( \
	(char *(*)())d2i_X509AT,PEM_STRING_X509,bp,(char **)x,cb,u)

/************************************************************************/


DECLARE_ASN1_FUNCTIONS(X509AT_ATTRIBUTE)


DECLARE_ASN1_FUNCTIONS(X509AT_VAL)


DECLARE_ASN1_FUNCTIONS(X509AT_ISSUER_SERIAL)


DECLARE_ASN1_FUNCTIONS(X509AT_OBJECTDIGESTINFO)


DECLARE_ASN1_FUNCTIONS(X509AT_HOLDER)


DECLARE_ASN1_FUNCTIONS(X509AT_V2FORM)


DECLARE_ASN1_FUNCTIONS(X509AT_ATTCERTISSUER)


DECLARE_ASN1_FUNCTIONS(X509AT_CINF)


DECLARE_ASN1_FUNCTIONS(X509AT)


/***************************************************************************

BEGIN_ANYADIDO por mi 01/06/2003

***************************************************************************/
#ifdef  __cplusplus
}
#endif

/***************************************************************************

END_ANYADIDO por mi 01/06/2003

***************************************************************************/
#endif
